<?php
// registration.php
require_once __DIR__ . '/config.php';

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome       = trim($_POST['nome'] ?? '');
    $email      = trim($_POST['email'] ?? '');
    $password   = trim($_POST['password'] ?? '');
    $password2  = trim($_POST['password2'] ?? '');

    // Validações básicas
    if ($nome === '' || $email === '' || $password === '' || $password2 === '') {
        $error = 'Todos os campos são obrigatórios.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Formato de e-mail inválido.';
    } elseif ($password !== $password2) {
        $error = 'As senhas não coincidem.';
    } elseif (strlen($password) < 6) {
        $error = 'A senha deve ter pelo menos 6 caracteres.';
    } else {
        // Verifica se já existe usuário com esse e-mail
        $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ? LIMIT 1');
        $stmt->execute([$email]);
        if ($stmt->fetch()) {
            $error = 'Já existe uma conta cadastrada com este e-mail.';
        } else {
            // Insere novo usuário
            $hash = password_hash($password, PASSWORD_BCRYPT);
            $stmt = $pdo->prepare('INSERT INTO users (nome, email, senha_hash) VALUES (?, ?, ?)');
            $ok = $stmt->execute([$nome, $email, $hash]);
            if ($ok) {
                $success = 'Cadastro realizado com sucesso. Você já pode <a href="login.php">entrar</a>.';
            } else {
                $error = 'Ocorreu um erro ao cadastrar. Tente novamente.';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Registro – ChatGPT Clone</title>
  <link rel="stylesheet" href="public/assets/css/styles.css">
</head>
<body>
  <div class="login-container">
    <h2>Crie sua conta</h2>

    <?php if ($error): ?>
      <div class="alert error"><?= htmlspecialchars($error) ?></div>
    <?php elseif ($success): ?>
      <div class="alert success"><?= $success ?></div>
    <?php endif; ?>

    <form method="POST" action="registration.php">
      <label for="nome">Nome:</label>
      <input type="text" id="nome" name="nome" value="<?= htmlspecialchars($nome ?? '') ?>" required>

      <label for="email">E-mail:</label>
      <input type="email" id="email" name="email" value="<?= htmlspecialchars($email ?? '') ?>" required>

      <label for="password">Senha:</label>
      <input type="password" id="password" name="password" required>

      <label for="password2">Confirme a Senha:</label>
      <input type="password" id="password2" name="password2" required>

      <button type="submit" class="btn">Registrar</button>
      <p class="small-text">Já tem conta? <a href="login.php">Entre aqui</a>.</p>
    </form>
  </div>
</body>
</html>
