<?php
// /chat/controllers/AgentController.php
require_once __DIR__ . '/../config.php';
header('Content-Type: application/json; charset=utf-8');

if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Não autorizado']);
    exit;
}

$userId   = $_SESSION['user_id'];
$agentId  = isset($_POST['id']) ? (int) $_POST['id'] : 0;
$nome     = trim($_POST['nome'] ?? '');
$descricao = trim($_POST['descricao'] ?? '');
$configJson = trim($_POST['config_json'] ?? '');

// Validação básica: nome e configurações são obrigatórios
if ($nome === '' || $configJson === '') {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Nome e configurações são obrigatórios']);
    exit;
}

// Valida JSON em configJson
$decodedCfg = json_decode($configJson, true);
if (!is_array($decodedCfg)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Configurações inválidas']);
    exit;
}

if ($agentId > 0) {
    // Edição de agente existente: verifica se pertence ao usuário
    $stmt = $pdo->prepare('SELECT id FROM agents WHERE id = ? AND user_id = ? LIMIT 1');
    $stmt->execute([$agentId, $userId]);
    if (!$stmt->fetch()) {
        http_response_code(403);
        echo json_encode(['success' => false, 'error' => 'Agente não encontrado']);
        exit;
    }

    // Atualiza registro do agente
    $stmt = $pdo->prepare('
        UPDATE agents
        SET nome = ?, descricao = ?, config_json = ?, updated_at = CURRENT_TIMESTAMP
        WHERE id = ? AND user_id = ?
    ');
    $stmt->execute([$nome, $descricao, $configJson, $agentId, $userId]);
} else {
    // Cria novo agente
    $stmt = $pdo->prepare('
        INSERT INTO agents (user_id, nome, descricao, config_json)
        VALUES (?, ?, ?, ?)
    ');
    $stmt->execute([$userId, $nome, $descricao, $configJson]);
    $agentId = (int) $pdo->lastInsertId();
}

// ------------------------------------------------
// 3) Processa upload dos arquivos de conhecimento
// ------------------------------------------------
if (!empty($_FILES['knowledge_files'])) {
    // Define diretório de upload: /public/uploads/agent_files/{userId}/{agentId}/
    $uploadDir = __DIR__ . '/../public/uploads/agent_files/' . $userId . '/' . $agentId . '/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $fileCount = count($_FILES['knowledge_files']['name']);
    for ($i = 0; $i < $fileCount; $i++) {
        if ($_FILES['knowledge_files']['error'][$i] === UPLOAD_ERR_OK) {
            $tmpName  = $_FILES['knowledge_files']['tmp_name'][$i];
            $origName = basename($_FILES['knowledge_files']['name'][$i]);
            // Gera nome seguro (timestamp + caracteres válidos)
            $safeName = time() . '_' . preg_replace('/[^a-zA-Z0-9_\.\-]/', '_', $origName);
            $destPath = $uploadDir . $safeName;

            if (move_uploaded_file($tmpName, $destPath)) {
                // Insere referência ao arquivo na tabela agent_files
                $stmt2 = $pdo->prepare('
                    INSERT INTO agent_files (agent_id, filename, file_path)
                    VALUES (?, ?, ?)
                ');
                // Grava caminho relativo para uso no front-end
                $relativePath = 'public/uploads/agent_files/' . $userId . '/' . $agentId . '/' . $safeName;
                $stmt2->execute([$agentId, $safeName, $relativePath]);
            }
        }
    }
}

// ------------------------------------------------
// 4) Retorna sucesso em JSON para o front-end
// ------------------------------------------------
echo json_encode(['success' => true, 'agent_id' => $agentId]);
