<?php
// update_conversation_model.php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json; charset=utf-8');

if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Não autorizado']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$convId = isset($input['conversation_id']) ? (int)$input['conversation_id'] : 0;
$model = trim($input['model'] ?? '');

if ($convId <= 0 || $model === '') {
    http_response_code(400);
    echo json_encode(['error' => 'Parâmetros inválidos']);
    exit;
}

// Verifica se a conversa existe e pertence ao usuário
$stmt = $pdo->prepare('SELECT id FROM conversations WHERE id = ? AND user_id = ? LIMIT 1');
$stmt->execute([$convId, $_SESSION['user_id']]);
if (!$stmt->fetch()) {
    http_response_code(403);
    echo json_encode(['error' => 'Conversa não encontrada']);
    exit;
}

// Atualiza o modelo
$stmt = $pdo->prepare('UPDATE conversations SET modelo = ?, updated_at = CURRENT_TIMESTAMP WHERE id = ? AND user_id = ?');
$stmt->execute([$model, $convId, $_SESSION['user_id']]);

echo json_encode(['success' => true]);
