<?php
// /chat/rename_conversation.php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json; charset=utf-8');

// Verifica autenticação
if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Não autorizado']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!is_array($input) || empty($input['conversation_id']) || empty($input['new_title'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Dados inválidos']);
    exit;
}

$userId = $_SESSION['user_id'];
$convid = (int)$input['conversation_id'];
$newTitle = trim($input['new_title']);

// Atualiza o título no banco
$stmt = $pdo->prepare('
    UPDATE conversations
    SET titulo = ?, updated_at = NOW()
    WHERE id = ? AND user_id = ?
');
$stmt->execute([$newTitle, $convid, $userId]);

if ($stmt->rowCount() > 0) {
    echo json_encode(['success' => true]);
} else {
    // Ou conversa não existe OU pertence a outro usuário
    http_response_code(404);
    echo json_encode(['success' => false, 'error' => 'Conversa não encontrada ou sem permissão']);
}
exit;
