<?php
// login.php
require_once __DIR__ . '/config.php';

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if ($email === '' || $password === '') {
        $error = 'Informe e-mail e senha.';
    } else {
        $stmt = $pdo->prepare('SELECT id, nome, senha_hash FROM users WHERE email = ? LIMIT 1');
        $stmt->execute([$email]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user && password_verify($password, $user['senha_hash'])) {
            $_SESSION['user_id']   = $user['id'];
            $_SESSION['user_name'] = $user['nome'];
            header('Location: index.php');
            exit;
        } else {
            $error = 'E-mail ou senha inválidos.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Login – ChatGPT Clone</title>
  <link rel="stylesheet" href="public/assets/css/styles.css">
</head>
<body>
  <div class="login-container">
    <h2>Entrar no ChatGPT Clone</h2>

    <?php if ($error): ?>
      <div class="alert error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" action="login.php">
      <label for="email">E-mail:</label>
      <input type="email" id="email" name="email" required>

      <label for="password">Senha:</label>
      <input type="password" id="password" name="password" required>

      <div class="login-buttons">
        <button type="submit" class="btn">Entrar</button>
        <button type="button" class="btn secondary" onclick="window.location.href='registration.php'">
          Registrar
        </button>
      </div>

      <p class="small-text">
        Ainda não tem conta? 
        <a href="registration.php">Registre-se aqui</a>.
      </p>
    </form>
  </div>
</body>
</html>
