<?php
// /chat/agent_list.php
require_once __DIR__ . '/config.php';
if (empty($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Meus Agentes – Cognis Chat</title>
  <link rel="stylesheet" href="public/assets/css/styles.css">
</head>
<body data-theme="<?= isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light' ?>">
  <?php include __DIR__ . '/views/header.php'; ?>

  <main class="app-container">
    <aside class="sidebar">
      <div class="sidebar-header" style="display: flex; justify-content: space-between; align-items: center; padding: 1rem;">
        <!-- Botão Voltar para Tela Principal -->
        <a href="index.php" class="btn btn-secondary">
          ← Tela Principal
        </a>
        <!-- Título da Sessão -->
        <h2 style="margin: 0; flex-grow: 1; text-align: center;">Agentes</h2>
        <!-- Botão Alternar Tema -->
        <button id="theme-toggle" class="btn btn-secondary">
          Alternar Tema
        </button>
      </div>
      <div class="sidebar-actions" style="padding: 0 1rem 1rem;">
        <a href="agent_form.php" class="btn btn-primary">
          + Criar Novo
        </a>
      </div>
      <div id="agent-list" class="chat-list" style="padding: 0 1rem;">
        <p class="placeholder">Carregando agentes…</p>
      </div>
    </aside>

    <section class="chat-area">
      <h2>Selecione um agente para editar</h2>
    </section>
  </main>

  <?php include __DIR__ . '/views/footer.php'; ?>

  <script type="module">
    import agentList from '/public/assets/js/agent_list.js';
    agentList();
  </script>

  <!-- JavaScript para alternar tema claro/escuro -->
  <script>
    document.addEventListener('DOMContentLoaded', () => {
      const themeToggleBtn = document.getElementById('theme-toggle');
      const rootEl = document.documentElement;

      function applyTheme(theme) {
        rootEl.setAttribute('data-theme', theme);
        localStorage.setItem('theme', theme);
      }

      // Aplica tema salvo ou detecta inicialmente
      const savedTheme = localStorage.getItem('theme');
      if (savedTheme) {
        applyTheme(savedTheme);
      } else if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
        applyTheme('dark');
      } else {
        applyTheme('light');
      }

      themeToggleBtn.addEventListener('click', () => {
        const current = rootEl.getAttribute('data-theme') === 'dark' ? 'dark' : 'light';
        const next = current === 'dark' ? 'light' : 'dark';
        applyTheme(next);
      });
    });
  </script>
</body>
</html>
