<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>ChatGPT Self-Hosted (gpt-4o)</title>
  <link rel="stylesheet" href="assets/style.css" />
</head>
<body class="light-mode">
  <div id="app">
    <!-- 1) Barra Lateral -->
    <aside class="sidebar">
      <div class="sidebar-header">
        <button id="btn-new-conversation" class="btn">Nova Conversa</button>
        <button id="btn-new-agent" class="btn">+ Novo Agente</button>
      </div>
      <ul id="conversation-list">
        <!-- Aqui serão listadas as conversas salvas -->
      </ul>
      <ul id="agent-list">
        <!-- Lista de agentes personalizados -->
      </ul>
      <div class="toggle-theme">
        <label>
          <input type="checkbox" id="toggle-darkmode" />
          Modo Escuro
        </label>
      </div>
    </aside>

    <!-- 2) Area de Chat -->
    <main class="chat-container">
      <div id="messages" class="messages">
        <!-- As mensagens (user + IA) aparecerão aqui -->
      </div>
      <div class="input-area">
        <select id="model-selector">
          <option value="gpt-3.5-turbo">gpt-3.5-turbo</option>
          <option value="gpt-4">gpt-4</option>
          <option value="gpt-4o">gpt-4o</option>
        </select>
        <textarea id="input-message" placeholder="Digite sua mensagem..." rows="1"></textarea>
        <button id="send-btn" class="btn-send">Enviar</button>
      </div>
    </main>

    <!-- 3) Modal/Seção para criação de agente -->
    <div id="agent-modal" class="modal hidden">
      <div class="modal-content">
        <h2>Criar / Editar Agente</h2>
        <form id="agent-form">
          <label for="agent-name">Nome do Agente:</label>
          <input type="text" id="agent-name" required />

          <label for="agent-model">Modelo:</label>
          <select id="agent-model">
            <option value="gpt-3.5-turbo">gpt-3.5-turbo</option>
            <option value="gpt-4">gpt-4</option>
            <option value="gpt-4o">gpt-4o</option>
          </select>

          <label for="agent-temp">Temperatura (0.0–1.0):</label>
          <input type="number" id="agent-temp" min="0" max="1" step="0.1" value="0.7" required />

          <label for="agent-instructions">Instruções (system prompt):</label>
          <textarea id="agent-instructions" rows="5" required></textarea>

          <input type="hidden" id="agent-id" value="" />
          <div class="modal-actions">
            <button type="submit" class="btn">Salvar</button>
            <button type="button" id="agent-cancel" class="btn-secondary">Cancelar</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <script src="assets/app.js"></script>
</body>
</html>
