<?php
require_once __DIR__ . '/../env.php';
header('Content-Type: application/json');

$agentsFile = __DIR__ . '/../data/agents.json';

if (!file_exists($agentsFile)) {
    file_put_contents($agentsFile, json_encode(new stdClass(), JSON_PRETTY_PRINT));
}

$raw = file_get_contents($agentsFile);
$agents = json_decode($raw, true);
if ($agents === null) {
    $agents = [];
}

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        echo json_encode($agents, JSON_PRETTY_PRINT);
        break;

    case 'POST':
        $input = json_decode(file_get_contents('php://input'), true);
        if (!isset($input['nome'], $input['modelo'], $input['temperatura'], $input['instrucoes'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Dados inválidos para criação']);
            exit;
        }
        $id = 'agent_' . time() . '_' . rand(1000, 9999);
        $agents[$id] = [
            'nome' => $input['nome'],
            'modelo' => $input['modelo'],
            'temperatura' => floatval($input['temperatura']),
            'instrucoes' => $input['instrucoes']
        ];
        file_put_contents($agentsFile, json_encode($agents, JSON_PRETTY_PRINT));
        echo json_encode($agents, JSON_PRETTY_PRINT);
        break;

    case 'PUT':
        $input = json_decode(file_get_contents('php://input'), true);
        if (!isset($input['id'], $input['nome'], $input['modelo'], $input['temperatura'], $input['instrucoes'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Dados inválidos para edição']);
            exit;
        }
        $id = $input['id'];
        if (!isset($agents[$id])) {
            http_response_code(404);
            echo json_encode(['error' => 'Agente não encontrado']);
            exit;
        }
        $agents[$id] = [
            'nome' => $input['nome'],
            'modelo' => $input['modelo'],
            'temperatura' => floatval($input['temperatura']),
            'instrucoes' => $input['instrucoes']
        ];
        file_put_contents($agentsFile, json_encode($agents, JSON_PRETTY_PRINT));
        echo json_encode($agents, JSON_PRETTY_PRINT);
        break;

    case 'DELETE':
        $input = json_decode(file_get_contents('php://input'), true);
        if (!isset($input['id'])) {
            http_response_code(400);
            echo json_encode(['error' => 'ID de agente não fornecido']);
            exit;
        }
        $id = $input['id'];
        if (!isset($agents[$id])) {
            http_response_code(404);
            echo json_encode(['error' => 'Agente não encontrado']);
            exit;
        }
        unset($agents[$id]);
        file_put_contents($agentsFile, json_encode($agents, JSON_PRETTY_PRINT));
        echo json_encode($agents, JSON_PRETTY_PRINT);
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Método não permitido']);
        break;
}
