// /chat/public/assets/js/secondary.js
// Este arquivo só deverá ser incluído em “agent_chat.php”.
// Ele detecta se há um #agent-id e, se houver, envia as requisições para o handler de agentes.

document.addEventListener('DOMContentLoaded', () => {
  const sendBtn       = document.getElementById('send-btn');
  const chatInputEl   = document.getElementById('chat-input');
  const chatMessagesEl= document.getElementById('chat-messages');
  const agentIdInput  = document.getElementById('agent-id');
  const modelSelectEl = document.getElementById('model-select');
  let currentAgentId  = agentIdInput ? parseInt(agentIdInput.value, 10) : null;
  let currentModel    = modelSelectEl ? modelSelectEl.value : 'gpt-3.5-turbo';

  if (!currentAgentId) {
    // Se não há agent-id, não fazemos nada neste script.
    return;
  }

  // Atualiza modelo se o usuário mudar a seleção
  modelSelectEl.addEventListener('change', () => {
    currentModel = modelSelectEl.value;
  });

  // Captura ENTER e SHIFT+ENTER
  chatInputEl.addEventListener('keydown', (e) => {
    if (e.key === 'Enter' && !e.shiftKey) {
      e.preventDefault();
      sendBtn.click();
    }
    // SHIFT+ENTER permite pular linha naturalmente
  });

  // Anexa mensagem do usuário na interface
  function appendUserMessage(text) {
    if (chatMessagesEl.querySelector('.placeholder')) {
      chatMessagesEl.innerHTML = '';
    }
    const userMsg = document.createElement('div');
    userMsg.classList.add('message', 'user');
    userMsg.textContent = text;
    chatMessagesEl.appendChild(userMsg);
    chatMessagesEl.scrollTop = chatMessagesEl.scrollHeight;
  }

  // Anexa mensagem do assistente
  function appendAssistantMessage(text) {
    const assistantMsg = document.createElement('div');
    assistantMsg.classList.add('message', 'assistant');
    assistantMsg.textContent = text;
    chatMessagesEl.appendChild(assistantMsg);
    chatMessagesEl.scrollTop = chatMessagesEl.scrollHeight;
  }

  function appendLoadingIndicator() {
    const loading = document.createElement('div');
    loading.classList.add('message', 'assistant');
    loading.setAttribute('id', 'loading-indicator');
    loading.textContent = 'O agente está processando…';
    chatMessagesEl.appendChild(loading);
    chatMessagesEl.scrollTop = chatMessagesEl.scrollHeight;
    return loading;
  }

  function removeLoadingIndicator() {
    const el = document.getElementById('loading-indicator');
    if (el) el.remove();
  }

  // Função que envia a mensagem para agent_chat_handler.php
  async function sendMessageToAgent(text) {
    const payload = {
      agent_id: currentAgentId,
      message: text,
      model: currentModel
    };
    try {
      const res = await fetch('agent_chat_handler.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(payload)
      });
      if (!res.ok) {
        const status = res.status;
        throw new Error('Status ' + status);
      }
      return await res.json();
    } catch (err) {
      console.error(err);
      return { error: err.message };
    }
  }

  // Ao clicar em “Enviar”
  sendBtn.addEventListener('click', async () => {
    const text = chatInputEl.value.trim();
    if (!text) return;

    appendUserMessage(text);
    chatInputEl.value = ''; // limpa a caixa imediatamente
    const loadingIndicator = appendLoadingIndicator();

    const result = await sendMessageToAgent(text);
    removeLoadingIndicator();

    if (result.error) {
      appendAssistantMessage('❗ Erro: ' + result.error);
      return;
    }

    // Exibe a resposta do Agente
    appendAssistantMessage(result.agent_response);
  });
});
