<?php
// get_conversation_model.php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json; charset=utf-8');

if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Não autorizado']);
    exit;
}

$convId = isset($_GET['conversation_id']) ? (int)$_GET['conversation_id'] : 0;
if ($convId <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'ID inválido']);
    exit;
}

// Busca o modelo da conversa
$stmt = $pdo->prepare('SELECT modelo FROM conversations WHERE id = ? AND user_id = ? LIMIT 1');
$stmt->execute([$convId, $_SESSION['user_id']]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$row) {
    http_response_code(404);
    echo json_encode(['error' => 'Conversa não encontrada']);
    exit;
}

echo json_encode(['model' => $row['modelo']]);
